<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5" />
    <meta name="apple-mobile-web-app-capable" content="yes" />

    <link rel="apple-touch-icon-precomposed" sizes="57x57" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-57x57.png" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-114x114.png" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-72x72.png" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-144x144.png" />
    <link rel="apple-touch-icon-precomposed" sizes="60x60" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-60x60.png" />
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-120x120.png" />
    <link rel="apple-touch-icon-precomposed" sizes="76x76" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-76x76.png" />
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/apple-touch-icon-152x152.png" />
    <link rel="icon" type="image/png" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/favicon-196x196.png" sizes="196x196" />
    <link rel="icon" type="image/png" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/favicon-96x96.png" sizes="96x96" />
    <link rel="icon" type="image/png" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/favicon-32x32.png" sizes="32x32" />
    <link rel="icon" type="image/png" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/favicon-16x16.png" sizes="16x16" />
    <link rel="icon" type="image/png" href="<?php bloginfo('template_url'); ?>/assets/img/favicon/favicon-128.png" sizes="128x128" />
    <meta name="application-name" content="Difinative" />
    <meta name="msapplication-TileColor" content="#FF004B" />
    <meta name="msapplication-TileImage" content="<?php bloginfo('template_url'); ?>/assets/img/favicon/mstile-144x144.png" />
    <meta name="msapplication-square70x70logo" content="<?php bloginfo('template_url'); ?>/assets/img/favicon/mstile-70x70.png" />
    <meta name="msapplication-square150x150logo" content="<?php bloginfo('template_url'); ?>/assets/img/favicon/mstile-150x150.png" />
    <meta name="msapplication-wide310x150logo" content="<?php bloginfo('template_url'); ?>/assets/img/favicon/mstile-310x150.png" />
    <meta name="msapplication-square310x310logo" content="<?php bloginfo('template_url'); ?>/assets/img/favicon/mstile-310x310.png" />

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <div id="body-wrapper">

        <!-- Header -->
        <header id="header" class="x-fade">
            <div class="header-inner">

                <!-- Logo -->
                <a href="<?php bloginfo('url'); ?>" id="logo" title="Difinative"><img src="<?php bloginfo('template_url'); ?>/assets/img/logo.svg" alt="Difinative Logo"></a>


                <!-- Menu Button -->
                <a href="#" title="Menu Button" id="menu-button">
                    <i class="icon-menu-button"></i>
                    <i class="icon-menu-button-close"></i>
                </a>


                <!-- Menu -->
                <nav class="nav">
                    <?php wp_nav_menu(array('menu' => 2, 'container' => false)); ?>
                </nav>

            </div>
        </header>