<!-- Shape Model -->
<section class="shape-model-container grid-outer">
    <article class="shape-model grid">

        <!-- Shape Model Description -->
        <div class="shape-model-description">
            <h2 class="large-heading text-to-animate"><?php echo $content['title'] ?></h2>
            <h3 class="text-to-animate"><?php echo $content['subtitle'] ?></h3>
            <svg class="animate-svg x-fade" width="1008" height="804" viewBox="0 0 1008 804" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M23.5 203.333C264.548 203.333 676.797 342.447 698.854 58.2574C718.675 -196.776 264.688 552.761 264.688 552.761L770.682 251.385C770.682 251.385 202.025 -82.8727 389.311 323.156C553.007 678.107 1065.32 365.245 995.987 141.69L264.688 798.544L896.5 706.333" stroke="#FF004B" stroke-width="10" stroke-linejoin="round" />
                <path class="delay-large" d="M893.455 683.793L904.131 689.606C912.898 694.379 916.456 705.534 912.072 714.502L906.733 725.423" stroke="#FF004B" stroke-width="10" stroke-miterlimit="10" />
                <path d="M18.5813 225.969L10.1763 217.187C3.27457 209.975 3.27458 198.266 10.1763 191.055L18.5813 182.272" stroke="#FF004B" stroke-width="10" stroke-miterlimit="10" />
            </svg>
        </div>


        <!-- Items -->
        <div class="items">

            <?php foreach ($content['item'] as $item) : ?>
                <!-- Item -->
                <div class="item x-fade x-fade-down">

                    <!-- Title -->
                    <div class="title">
                        <h4 class="h3"><?php echo $item['title']; ?></h4>
                    </div>

                    <!-- Image -->
                    <div class="image">
                        <?php echo get_svg($item['image'], ['class' => 'animate-svg x-fade']);
                        ?>
                    </div>

                    <!-- Text -->
                    <div class="text visible">
                        <p><?php echo $item['text']; ?></p>
                    </div>

                </div>
            <?php endforeach; ?>

        </div>

    </article>
</section>