$ = jQuery.noConflict();

let vh = window.innerHeight * 0.01;
document.documentElement.style.setProperty('--vh', `${vh}px`);

window.addEventListener('resize', () => {
    let vh = window.innerHeight * 0.01;
    document.documentElement.style.setProperty('--vh', `${vh}px`);
});

// Usage: height: calc(var(--vh, 1vh) * 100);

// Resize Items Function
resizeItems = function () {
    // Case Study
    if ($(".case-study .images").length) {
        $(".case-study .images .images-inner").css('width', $(window).width() - $(".case-study .images").offset().left);
    };


    // CTA V2
    if ($(".cta.v2 .image").length) {
        $(".cta.v2 .image .image-inner").css('width', $(window).width() - $(".cta.v2 .image").offset().left);
    };


    // Text Image
    if ($(".text-image").length) {
        $(".text-image:not(.image-first) .image-inner").css('width', $(window).width() - $(".text-image:not(.image-first) .image").offset().left);
    };

    if ($(".text-image.image-first").length) {
        $(".text-image.image-first .image-inner").css('width', $(".text-image.image-first .image").width() + $(".text-image.image-first").offset().left);
    };
};


$(window).on('load', function () {
    // Resize Items
    resizeItems();


    // Transitional Effects
    setTimeout(function () {
        $("body a, body input[type='submit'], button").addClass("loaded");
    }, 1000);


    // Animations
    if ($(window).width() > 1200) {
        $(".animate-on-load").addClass('x-fade-active');

        $(window).on('scroll', function () {
            var delay = 0;
            $('.x-fade:not(.x-fade-active):not(.text-block)').each(function () {
                var self = $(this);
                if (self.isInViewportAnimation()) {
                    setTimeout(() => {
                        self.addClass('x-fade-active');
                    }, delay);
                }
                delay += 250;
            });
        });

        $(window).trigger('scroll');
    };
});


$(document).ready(function () {
    // Resize Items
    resizeItems();


    // Force Scroll Top
    window.onbeforeunload = function () {
        if ($(window).width() > 1200) {
            window.scrollTo(0, 0);
        };
    };


    // Scrolled
    $(window).on('scroll', function () {
        if ($(window).scrollTop() > 50) {
            $("body").addClass('scrolled');
        } else {
            $("body").removeClass('scrolled');
        };
    });


    // Menu
    $("body").on('click', '#menu-button', function (e) {
        e.preventDefault();
        $this = $(this);
        if ($this.hasClass('active')) {
            $this.removeClass('active');
            $("body").removeClass('menu-open');
        } else {
            $this.addClass('active');
            $("body").addClass('menu-open');
        };
    });


    // Hero Banner Line Draw Animation
    if ($(".hero-banner-container").length && $("#drawingCanvas").length) {
        var points = []
        var maxPoints = 5000;
        var fadeInterval = 10;
        var lineWidthSize = 24;
        if ($(window).width() < 1500) {
            lineWidthSize = 20;
        };

        if ($(window).width() < 1200) {
            $("#drawingCanvas").remove();
        } else {
            initialize();

            function getPosition(mouseEvent, sigCanvas) {
                var rect = sigCanvas.getBoundingClientRect();
                return {
                    X: mouseEvent.clientX - rect.left,
                    Y: mouseEvent.clientY - rect.top
                };
            }

            function initialize() {
                // get references to the canvas element as well as the 2D drawing context
                var sigCanvas = document.getElementById("drawingCanvas");
                sigCanvas.width = $(".hero-banner-container").outerWidth(true);
                sigCanvas.height = $(".hero-banner-container").height();

                window.addEventListener("resize", function () {
                    sigCanvas.width = $(".hero-banner-container").outerWidth(true);
                    sigCanvas.height = $(".hero-banner-container").height();
                });

                var context = sigCanvas.getContext("2d");
                context.imageSmoothingEnabled = true;
                context.lineJoin = "round";
                context.lineWidth = lineWidthSize;

                var fadeIntervalId = setInterval(function () {
                    points.forEach(function (point, i) {
                        point.opacity -= 0.01;
                        if (point.opacity < 0) {
                            points.splice(i, 1);
                        }
                    });
                    draw();
                }, fadeInterval);

                $("#drawingCanvas").mousemove(function (mouseEvent) {
                    var position = getPosition(mouseEvent, sigCanvas);
                    points.push({ x: position.X, y: position.Y, opacity: 1 });
                    if (points.length > maxPoints) {
                        points.shift();
                    }
                });


                function draw() {
                    context.clearRect(0, 0, sigCanvas.width, sigCanvas.height);
                    context.beginPath();
                    for (var i = 0; i < points.length; i++) {
                        context.strokeStyle = "rgba(255, 0, 75, " + points[i].opacity + ")";
                        context.lineTo(points[i].x, points[i].y);
                        context.lineTo(points[i].x + 0.001, points[i].y);
                        context.lineTo(points[i].x - 0.001, points[i].y);
                    }
                    context.stroke();
                }
            };
        };
    };


    // Text to Animate
    if ($(".text-to-animate").length && $(window).width() > 1200) {
        if ($(".quote-banner.v3 h2").length) {
            $(".quote-banner.v3 h2").removeClass('text-to-animate');
            $(".quote-banner.v3 h2 small").appendTo($(".quote-banner.v3 h2 span").last());
        };
        $(".text-to-animate").each(function (i) {
            $this = $(this);
            var spanInserted = $this.html().split(" ").join(" </span><span class='x-fade x-fade-down'>");
            var wrapped = ("<span class='x-fade x-fade-down'>").concat(spanInserted, "</span>");
            $this.html(wrapped);
            var refPos = $this.find('span:first-child').position().top;
            var newPos;
            $this.find('span')
            $this.find('span').each(function (index) {
                newPos = $(this).position().top
                if (index == 0) {
                    return;
                }
                if (newPos == refPos) {
                    $(this).prepend($(this).prev().text() + " ");
                    $(this).prev().remove();
                }
                refPos = newPos;
            });
        })
    };

    $(window).trigger('scroll');


    // Quote Banner
    if ($(".quote-banner").length) {
        var svg1 = '<span class="animate-svg animate-svg-1 x-fade"><svg width="715" height="215" viewBox="0 0 715 215" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M364.557 196.832C124.241 196.832 3 153.034 3 107.73C3 62.4247 146.81 21.6082 329.512 17.9789" stroke="#FF004B" stroke-width="5" stroke-linejoin="round" /><path d="M365.641 18.6627C572.399 18.6627 712.001 62.4773 712.001 107.747C712.001 153.017 572.631 192.676 393.979 197.305" stroke="#FF004B" stroke-width="5" stroke-linejoin="round" /><path class="delay" d="M332.082 2L338.111 8.30666C343.062 13.4853 343.062 21.8942 338.111 27.0728L332.082 33.3795" stroke="#FF004B" stroke-width="5" stroke-miterlimit="10" /><path class="delay" d="M391.621 213L385.592 206.693C380.641 201.515 380.641 193.106 385.592 187.927L391.621 181.621" stroke="#FF004B" stroke-width="5" stroke-miterlimit="10" /></svg></span>';
        var svg2 = '<span class="animate-svg animate-svg-2 x-fade"><svg width="455" height="100" viewBox="0 0 455 100" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M17.9544 63.8902L9.93733 55.5134C3.35422 48.635 3.35422 37.466 9.93733 30.5876L17.9544 22.2108" stroke="#FF004B" stroke-width="10" stroke-miterlimit="10" /><path d="M436.991 22.2108L445.008 30.5875C451.591 37.466 451.591 48.6349 445.008 55.5134L436.991 63.8901" stroke="#FF004B" stroke-width="10" stroke-miterlimit="10" /><path d="M19.4414 42.8967L111.011 10.7895L63.694 94.6951L206.872 18.5089L171.474 63.1003L265.24 28.0898L266.074 53.229L327.694 18.5089L285.553 82.1596L399.19 5L369.768 50.8722L435.678 42.8967" stroke="#FF004B" stroke-width="10" stroke-linejoin="round" /></svg></span>';

        $(".quote-banner").each(function () {
            $banner = $(this);
            if ($($banner).find('.large-heading strong')) {
                if ($banner.find('strong').length > 1) {
                    $($banner).find('.large-heading strong').first().append(svg1);
                    $($banner).find('.large-heading strong').last().append(svg2);
                } else {
                    $($banner).find('.large-heading strong').first().append(svg1);
                };
            };
        });
    };


    // Hero Banner V3
    if ($(".hero-banner.v3").length) {
        var svg1 = '<span class="animate-svg animate-svg-1 x-fade"><svg width="662" height="117" viewBox="0 0 662 117" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M25.7718 65.0219L15.3228 59.9958C6.74277 55.8687 2.81876 45.4117 6.56559 36.6589L11.1286 25.9995" stroke="#FF004B" stroke-width="10" stroke-miterlimit="10"/><path d="M638.999 25.5142L648.49 32.1756C656.283 37.6456 658.451 48.6022 653.328 56.6275L647.089 66.401" stroke="#FF004B" stroke-width="10" stroke-miterlimit="10"/><path d="M18.4414 44.8967L110.011 12.7895L62.694 96.6951L205.872 20.5089L170.474 65.1003L264.24 30.0898L265.074 55.229L326.694 20.5089L284.553 84.1596L398.19 7L368.768 52.8722L431.5 44.8967L389.5 96.6954L487 38.5003L481 65.1006L546.5 30.0898L513 112L606 7L581 65.1003L638.5 44.8967" stroke="#FF004B" stroke-width="10" stroke-linejoin="round"/></svg></span>';

        $(".hero-banner.v3").each(function () {
            $banner = $(this);
            if ($($banner).find('.large-heading strong')) {
                if ($banner.find('strong').length) {
                    $($banner).find('.large-heading strong').append(svg1);
                };
            };
        });
    };


    // Services
    if ($(".services").length) {
        $(window).on('scroll', function () {
            $(".services .service").each(function () {
                $service = $(this);
                if ($service.isInViewportAnimation) {
                    var firstTop = $service.find('.image').offset().top;
                    var winScrollTop = $(window).scrollTop();
                    var shiftDistance = (firstTop - winScrollTop) * 0.06;
                    $service.find('.image.x-fade-active').css("transform", "translateY(" + shiftDistance + "px)");
                }
            });
        });
    };


    // Projects Slider
    if ($(".projects .owl-carousel").length) {
        var margin = 96;
        var autoplay = true;
        var autoplayHoverPause = true;
        if ($(window).width() < 1200 && $(window).width() > 767) {
            margin = 40;
            autoplay = false;
            autoplayHoverPause = false;
        } else if ($(window).width() < 767) {
            margin = 24;
            autoplay = false;
            autoplayHoverPause = false;
        };
        var owl = $(".projects .owl-carousel")
        owl.owlCarousel({
            dots: false,
            nav: false,
            autoplay: autoplay,
            autoplayTimeout: 10000,
            autoplayHoverPause: autoplayHoverPause,
            slideBy: 1,
            autoWidth: true,
            loop: true,
            margin: margin
        });

        owl.on('changed.owl.carousel', function (event) {
            $(".projects .owl-carousel .item h6").adjustHeight()
        })
    };


    // Projects Slider
    if ($(".partners-carousel .owl-carousel").length) {
        $(".partners-carousel .owl-carousel").owlCarousel({
            dots: false,
            nav: false,
            autoplay: false,
            autoplayTimeout: 4000,
            autoplayHoverPause: autoplayHoverPause,
            slideBy: 1,
            autoWidth: false,
            loop: true,
            margin: 0,
            items: 3,
            responsive: {
                0: {
                    autoplay: true,
                    items: 2,
                    autoplayTimeout: 2500
                },
                768: {
                    autoplay: false,
                    items: 3,
                    autoplayTimeout: 4000
                }
            }
        });

    };


    // Custom Cursor
    if ($(".custom-cursor").length) {
        $(document).on('mousemove', function (e) {
            $('.custom-cursor').css({
                left: e.pageX,
                top: e.pageY - $(window).scrollTop()
            });
        });
    };


    // Shape Model Items Hover
    if ($(".shape-model .items").length) {
        var maxHeight = 0;

        $(".shape-model .item").each(function () {
            $item = $(this);
            if ($item.find('.text').height() > maxHeight) {
                maxHeight = $item.find('.text').height() + 20;
            };
        });

        $(".shape-model .items .item .text").removeClass('visible');
        $(".shape-model .items").css('min-height', $(".shape-model .items .item").height() + maxHeight);

        if ($(window).width() > 1200) {
            $(".shape-model .item").mouseenter(function () {
                $this = $(this);
                $this.find('.text').stop().css('opacity', 0).slideDown(300, 'easeOutQuart').animate(
                    { opacity: 1 },
                    { queue: false, duration: 'easeOutQuart' }
                );
            });

            $(".shape-model .item").mouseleave(function () {
                $this = $(this);
                $this.find('.text').stop().animate(
                    { opacity: 0 },
                    { queue: false, duration: 'easeOutQuart' }
                ).slideUp(300, 'easeOutQuart').css('opacity', 0);
            });
        } else {

        }
    };


    // Get in Touch
    if ($(".get-in-touch .col .icon").length) {
        $(".get-in-touch .col .icon").adjustHeight();
    };


    // Buttons
    $("body").on('click', '.button:not(.play-again):not(.submit):not(.contact-button)', function (e) {
        e.preventDefault();
        $this = $(this);
        $href = $this.attr('href');
        if ($href.indexOf('#') >= 0) {
            if ($href.indexOf('#open-') >= 0) {
                $modal = $href.replace('open-', '');
                $($modal).addClass('visible');
                $("body").addClass('modal-visible ');
                $("body").attr('data-modal', $modal);
            } else if ($($href).length) {
                $('.x-fade:not(.x-fade-active):not(.text-block)').each(function () {
                    var delay = 0;
                    $('.x-fade:not(.x-fade-active):not(.text-block)').each(function () {
                        var self = $(this);
                        setTimeout(() => {
                            self.addClass('x-fade-active');
                        }, delay);
                        delay += 20;
                    });
                });
                $('html, body').animate({
                    scrollTop: $($href).offset().top
                }, 2000, 'easeOutQuart');
            }
        } else {
            window.location.href = $href;
        };
    });

    $("body").on('click', '.modal-wrapper.visible button.submit', function (e) {
        e.preventDefault();
        $(".modal-wrapper.visible form").submit();
    });


    // Modals
    $("body").on('click', '.modal-container, .close-modal-button', function () {
        if ($("body").hasClass('modal-visible')) {
            $("body").removeClass('modal-visible');
            $(".modal-wrapper").removeClass('visible');
            $("body").removeAttr('data-modal');
        };
    });

    $("body").on('click', '.modal', function (e) {
        e.stopPropagation();
        e.preventDefault();
    });




    // Go to Top
    $("body").on('click', '#go-to-top', function (e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, 2000, 'easeOutQuart');
    });


    // Case Study
    if ($(".case-study .text-block").length) {
        var index = 0;
        $(window).scroll(function () {
            $(".case-study .text-block").each(function () {
                $this = $(this);
                if ($(window).scrollTop() >= $this.offset().top - ($(window).height() / 2)) {
                    $this.addClass('active');
                    $this.addClass('x-fade-active');
                    index = $(".case-study .text-block.active").last().index() + 1;
                    $(".case-study .images img").removeClass('visible');
                    $(".case-study .images img:nth-child(" + index + ")").addClass('visible');
                } else {
                    $this.removeClass('active');
                    index = $(".case-study .text-block.active").last().index() + 1;
                    $(".case-study .images img").removeClass('visible');
                    $(".case-study .images img:nth-child(" + index + ")").addClass('visible');
                };
            });
        });
    };


    // Expertise
    if ($(".expertise .text-block").length) {
        var index = 0;
        $(window).scroll(function () {
            $(".expertise .text-block").each(function () {
                $this = $(this);
                if ($(window).scrollTop() >= $this.offset().top - 400) {
                    $this.addClass('active');
                    $(".expertise-container").addClass('visible');
                };
            });
        });
    };


    // Numbers
    if ($(".numbers .counter").length) {
        if ($(window).width() > 1200) {
            $(window).scroll(function () {
                $('.numbers .x-fade-active .counter').each(function () {
                    var $this = $(this).find('.val'),
                        countTo = $this.parent().attr('data-count');
                    if (!$this.parent().hasClass('started-counting')) {
                        $this.parent().addClass('started-counting');
                        $({ countNum: $this.text() }).animate({
                            countNum: countTo
                        }, {
                            duration: 2000,
                            easing: 'linear',
                            step: function () {
                                $this.text(Math.floor(this.countNum));
                            },
                            complete: function () {
                                $this.text(this.countNum);
                            }
                        });
                    };
                });
            });
        } else {
            $(window).scroll(function () {
                $('.numbers .counter').each(function () {
                    var $this = $(this).find('.val'),
                        countTo = $this.parent().attr('data-count');
                    if (!$this.parent().hasClass('started-counting')) {
                        $this.parent().addClass('started-counting');
                        $({ countNum: $this.text() }).animate({
                            countNum: countTo
                        }, {
                            duration: 2000,
                            easing: 'linear',
                            step: function () {
                                $this.text(Math.floor(this.countNum));
                            },
                            complete: function () {
                                $this.text(this.countNum);
                            }
                        });
                    };
                });
            });
        };
    };


    // Join Us
    if ($(".join-us .filters-menu").length) {
        $("body").on('click', '.filters-menu a', function (e) {
            e.preventDefault();
            $this = $(this);
            if (!$this.hasClass('active')) {
                category = $this.data('filter');
                $items = $this.parents('.join-us').find('.items');
                $this.parent().parent().find('a').removeClass('active');
                $this.addClass('active');
                if (category === '') {
                    $items.animate({ opacity: 0 }, 300, function () {
                        $items.find('.item').show();
                        $items.animate({ opacity: 1 }, 300);
                    });
                } else {
                    $items.animate({ opacity: 0 }, 300, function () {
                        $items.find('.item').hide();
                        $items.find('.item[data-category="' + category + '"]').show();
                        $items.animate({ opacity: 1 }, 300);
                    });
                };
            };
        });
    };


    // Text Image
    if ($(".text-image").length) {
        $(window).on('scroll', function () {
            $(".text-image").each(function () {
                $textImage = $(this);
                if ($textImage.isInViewportAnimation) {
                    var firstTop = $textImage.find('.image').offset().top;
                    var winScrollTop = $(window).scrollTop();
                    var shiftDistance = (firstTop - winScrollTop) * 0.15;
                    $textImage.find('.image').css("transform", "translateY(" + shiftDistance + "px)");
                }
            });
        });
    };


    // Contact
    if ($(".contact-container").length) {
        var offset = 0;
        $(window).on('scroll', function () {
            if ($(".contact-container .contact .left").hasClass('x-fade-active')) {
                $(".contact-container").addClass('visible');
            };

            if ($(window).width() > 991) {
                offset = 200;
            } else {
                offset = 300;
            };

            if ($(window).scrollTop() >= $(".contact .first-section").offset().top + $(".contact .first-section .inner").height() - offset) {
                $(".contact-container").addClass('dark');
            } else {
                $(".contact-container").removeClass('dark');
            };
        });


        if (window.location.hash == "#contact-form") {
            $('html, body').animate({
                scrollTop: $(".contact-section.second-section").offset().top
            }, 1000, 'easeOutQuart');
        }
    }
});


var w = $(window).width();
$(window).resize(function () {
    // Resize Items
    if ($(window).width() == w) return;
    w = $(window).width();
    resizeItems();
});


// Adjust Height Function
$.fn.adjustHeight = function () {
    var maxHeightFound = 0;
    this.css('min-height', '1px');
    if (this.is('a')) {
        this.removeClass('loaded');
    };
    this.each(function () {
        if ($(this).height() > maxHeightFound) {
            maxHeightFound = $(this).height();
        }
    });
    this.css('min-height', maxHeightFound);
    if (this.is('a')) {
        this.addClass('loaded');
    };
};


// Adjust OuterHeight Function
$.fn.adjustOuterHeight = function () {
    var maxHeightFound = 0;
    if (this.is('a')) {
        this.removeClass('loaded');
    };
    this.css('min-height', '1px');
    this.each(function () {
        if ($(this).outerHeight(true) > maxHeightFound) {
            maxHeightFound = $(this).outerHeight(true);
        }
    });
    this.css('min-height', maxHeightFound);
    if (this.is('a')) {
        this.addClass('loaded');
    };
};


// Adjust Height For N Items Function
$.fn.setMinHeight = function (setCount) {
    $this = this;
    this.css('min-height', '1px');
    this.find('a').removeClass('loaded');
    for (var i = 0; i < this.length; i += setCount) {
        var curSet = this.slice(i, i + setCount),
            height = 0;
        curSet.each(function () { height = Math.max(height, $(this).height()); })
            .css('min-height', height);
    }
    setTimeout(function () {
        $this.find('a').addClass('loaded');
    }, 200);
    return this;
};


// Adjust OuterHeight For N Items Function
$.fn.setMinOuterHeight = function (setCount, $boolean) {
    if (typeof $boolean === 'undefined') {
        $boolean = false;
    }
    $this = this;
    this.css('min-height', '1px');
    this.find('a').removeClass('loaded');
    for (var i = 0; i < this.length; i += setCount) {
        var curSet = this.slice(i, i + setCount),
            height = 0;
        curSet.each(function () { height = Math.max(height, $(this).outerHeight($boolean)); })
            .css('min-height', height);
    }
    setTimeout(function () {
        $this.find('a').addClass('loaded');
    }, 200);
    return this;
};


// Is In Viewport Function
$.fn.isInViewport = function () {
    var elementTop = $(this).offset().top - 70;
    var elementBottom = elementTop + $(this).outerHeight();
    var viewportTop = $(window).scrollTop();
    var viewportBottom = viewportTop + $(window).height();
    return elementBottom > viewportTop && elementTop < viewportBottom;
};



jQuery.fn.isInViewportAnimation = function () {
    var elementTop = $(this).offset().top;
    var elementBottom = elementTop + $(this).outerHeight();

    var viewportTop = $(window).scrollTop();
    var viewportBottom = viewportTop + $(window).height();

    return elementBottom > viewportTop && elementTop < viewportBottom;
};