<?php
/*
 * Plugin Name: Veribo ACF Preview
 * Plugin URI: https://veribo.ro/
 * Description: Easily preview ACF flexible content modules with screenshots.
 * Version: 1.0
 * Author: Veribo
 * Author URI: https://veribo.ro/
 * Text Domain: veribo-acf-preview
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/

add_action('admin_head', 'veribo_acf_preview');
function veribo_acf_preview() {
    if ( ! class_exists('ACF') ) return;

    function my_acf_load_field( $field ) {
        if ( $field['layouts'] ) :
        ?>
        <style>
            <?php echo file_get_contents(plugins_url('/css/style.css', __FILE__)); ?>
        </style>
        <script>
            <?php echo file_get_contents(plugins_url('/js/script.js', __FILE__)); ?>
        </script>
        <div class="vap-outer">
            <div class="vap-inner">
                <div class="vap">
                    <div class="vap-header">
                        <button>close</button>
                    </div>
                    <div class="vap-body">
                        <div class="vap-grid">
                            <?php foreach ( $field['layouts'] as $layout ) : ?>
                            <div class="vap-grid-item">
                                <div class="vap-item" data-name="<?php echo $layout['name']; ?>" data-key="<?php echo $layout['key']; ?>">
                                    <div class="vap-item-image">
                                        <div class="vap-item-file"><?php echo str_replace('_', '-', $layout['name']); ?>.php</div>
                                        <img src="<?php bloginfo('template_url'); ?>/flexible-content/preview/<?php echo str_replace('_', '-', $layout['name']); ?>.png" alt="<?php echo $layout['name']; ?> image">
                                    </div>
                                    <div class="vap-item-title"><?php echo $layout['label']; ?></div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="vap-footer">
                        <p>To add multiple modules, hold <kbd>SHIFT</kbd>.</p>
                    </div>
                </div>
            </div>
        </div>
        <?php
        endif;
        return $field;
    }
    add_filter('acf/load_field/type=flexible_content', 'my_acf_load_field');
}