(function($){
    $(document).ready(function () {
        $('body').on('click', 'a.acf-button[data-name="add-layout"]', function (e) {
            e.preventDefault();
            $('.acf-tooltip.acf-fc-popup').hide();
            $('.vap-outer').addClass('is-active');
            $('body').addClass('is-locked');
        });
        var shiftHeld = false;
        $('body').on('mousedown', function (e) { shiftHeld = e.shiftKey });
        $('body').on('click', '.vap-item', function (e) {
            e.preventDefault();
            var id = $(this).data('name');
            $('.acf-button[data-name="add-layout"]').trigger('click');
            $('.acf-fc-popup a[data-layout="' + id + '"]').trigger('click');
            if (!shiftHeld ) {
                $('.vap-outer').removeClass('is-active');
                $('body').removeClass('is-locked');
            }
        });
        $('body').on('click', '.vap-header button', function (e) {
            e.preventDefault();
            $('.vap-outer').removeClass('is-active');
            $('body').removeClass('is-locked');
        });
        $('body').on('click', '.vap-outer', function (e) {
            if (e.target !== this) {
                return;
            }
            e.preventDefault();
            $('.vap-outer').removeClass('is-active');
            $('body').removeClass('is-locked');
        });
        $('body').on('click', '.vap-inner', function (e) {
            if (e.target !== this) {
                return;
            }
            e.preventDefault();
            $('.vap-outer').removeClass('is-active');
            $('body').removeClass('is-locked');
        });
        
        $(document).on('keyup', function (e) {
            if (e.key == "Escape") {
                $('.vap-outer').removeClass('is-active');
                $('body').removeClass('is-locked');
            }
        });
    });
})(jQuery);