<?php get_header(); ?>

<section class="single-post-container grid-outer">
    <article class="single-post grid small">

        <!-- Breadcrumbs -->
        <div class="breadcrumbs">
            <a href="#">Blog</a>
            <span>/</span>
            <p><?php echo $post->post_title; ?></p>
        </div>


        <!-- Info -->
        <div class="single-post-info">
            <h1 class="h3"><?php echo $post->post_title; ?></h1>
            <span class="date"><?php echo $post->post_date; ?></span>
            <?php echo the_category($post->ID); ?>
        </div>


        <!-- Image -->
        <div class="single-post-image">
            <a href="<?php echo get_permalink($post->ID); ?>"><?php get_image(get_post_thumbnail_id($post->ID)); ?></a>
        </div>


        <!-- Content -->
        <div class="single-post-content">
            <?php echo apply_filters('the_content', $post->post_content);  ?>
        </div>

    </article>
</section>


<?php /* $items = get_posts(array('post_type' => 'post',  'numberposts' => 3, 'meta_query' => array(
    array(
        'key' => '_thumbnail_id',
        'compare' => 'EXISTS'
    ),
)));
foreach ($items as $item) : ?>

    <?php get_image(get_post_thumbnail_id($item));    ?>
<?php endforeach; */ ?>

<section class="dark text-cta-container grid-outer">
    <article class="text-cta grid">

        <!-- Text -->
        <div class="text-center">
            <h2 class="h1 text-to-animate">Like what you see?</h2>
            <h2 class="h1 text-to-animate">Get ready for digital transformation</h2>
            <a href="<?php echo get_permalink(254); ?>" class="x-fade x-fade-down button">Get in touch<i class="icon-button-arrow"></i></a>
        </div>
    </article>
</section>

<?php get_footer(); ?>