<?php get_header(); ?>

<section class="hero-banner-container grid-outer">

    <!-- Hero Banner Content -->
    <article class="hero-banner color-white grid  v2 color-white grid medium">
        <div class="text-left">
            <h1 class="text-to-animate large-heading"><?php echo get_post_type() == 'case-study' ? 'Portfolio' : 'Blog & News'; ?></h1>
        </div>

    </article>
</section>



<!-- Posts -->
<section class="posts-container grid-outer">
    <article class="posts grid small">
        <?php while (have_posts()) : the_post(); ?>

            <!-- Post -->
            <div class="post x-fade x-fade-down">

                <!-- Thumb -->
                <div class="post-thumb">
                    <a href="<?php echo get_permalink($post->ID); ?>"><?php get_image(get_post_thumbnail_id($post->ID)); ?></a>
                </div>

                <!-- Post Text -->
                <div class="post-text">
                    <h4><a href="<?php echo get_permalink($post->ID); ?>"><?php the_title(); ?></a></h4>
                    <span class="date"><?php echo get_the_date('d/m/Y', $post->ID); ?><?php the_category($post->ID); ?></span>
                    <p><?php echo character_limiter(strip_tags($post->post_content), 230, '...') ?></p>
                    <a href="#" class="button dark">Read more <i class="icon-button-arrow"></i></a>
                </div>

            </div>

        <?php endwhile; ?>
    </article>
</section>


<section class="dark text-cta-container grid-outer">
    <article class="text-cta grid">

        <!-- Text -->
        <div class="text-center">
            <h2 class="h1 text-to-animate">Like what you see?</h2>
            <h2 class="h1 text-to-animate">Get ready for digital transformation</h2>
            <a href="<?php echo get_permalink(254); ?>" class="x-fade x-fade-down button">Get in touch<i class="icon-button-arrow"></i></a>
        </div>
    </article>
</section>

<?php //flexible_content(get_field('content', 415)) 
?>

<?php get_footer(); ?>