<?php

require 'include/framework.php';
require 'include/custom-functions.php';

$framework = new \Veribo\Framework();

/**
 * Scripts
 *
 */
$framework->enqueue_script(array(
    'handle' => 'site-script',
    'src' => 'assets/js/site.min.js',
    'dependencies' => array('jquery', 'jquery-effects-core'),
), 'php', array(
    'ajax_url' => admin_url('admin-ajax.php'),
    'site_url' => get_bloginfo('url'),
));
$framework->enqueue_script(array(
    'handle' => 'movinwords-script',
    'src' => 'assets/vendor/movinwords/movinwords.min.js',
));

$framework->enqueue_script(array(
    'handle' => 'owl-carousel-script',
    'src' => 'assets/vendor/owlcarousel/owl.carousel.min.js',
));

/**
 * Styles
 *
 */
$framework->enqueue_style(array(
    'handle' => 'site-style',
    'src' => 'style.css',
));
$framework->enqueue_style(array(
    'handle' => 'site-custom-style',
    'src' => 'custom-style.css',
));

$framework->enqueue_style(array(
    'handle' => 'movinwords-style',
    'src' => 'assets/vendor/movinwords/movinwords.css',
));
$framework->enqueue_style(array(
    'handle' => 'owl-carousel-style',
    'src' => 'assets/vendor/owlcarousel/owl.carousel.min.css',
));
$framework->enqueue_style(array(
    'handle' => 'owl-theme-style',
    'src' => 'assets/vendor/owlcarousel/owl.carousel.min.css',
));

/**
 * Post Types
 *
 */
$framework->register_post_type(array(
    'slug' => 'case-study',
    'name' => array(
        'singular' => 'Case Study',
        'plural' => 'Case Studies',
    ),
    'supports' => array('title', 'thumbnail')
));


$framework->register_post_type(array(
    'slug' => 'job',
    'name' => array(
        'singular' => 'Job',
        'plural' => 'Jobs',
    ),
    'supports' => array('title', 'editor'),
    'publicly_queryable'  => false
));

$framework->register_post_type(array(
    'slug' => 'reusable_section',
    'name' => array(
        'singular' => 'Reusable Section',
        'plural' => 'Reusable Sections',
    ),
    'supports' => array('title'),
    'publicly_queryable' => false,
    'menu_icon' => 'dashicons-align-wide',
));


/**
 * Taxonomies
 * 
 */
$framework->register_taxonomy(array(
    'slug' => 'job-location',
    'post_types' => array('job'),
    'name' => array(
        'singular' => 'Location',
        'plural' => 'Locations',
    ),
));

/**
 * Image Sizes
 * 
 */
$framework->add_image_size('square', 200, 200);
$framework->add_image_size('portfolio-thumbnail', 492, 297);
$framework->add_image_size('case-study-content', 689, 790);

/**
 * Login Screen
 * 
 */
$framework->login_screen(array(
    'logo' => 'assets/img/logo-dark.svg',
    'logo_width' => '240px',
    'color' => '#19191E',
    'color_hover' => '#FF004B',
));

// Let's get the party started!
$framework->go();

add_filter('body_class', function ($classes) {
    global $post;
    if (isset($post->ID)) {
        $classes[] = get_field('header_style', $post->ID);
    }
    if (is_singular('post')) {
        $classes[] = 'dark-header';
    }
    return $classes;
});


// Gravity Forms Submit Button
add_filter('gform_submit_button', 'form_submit_button', 10, 2);
function form_submit_button($button, $form)
{
    return "<button class='button submit gform_button' id='gform_submit_button_{$form['id']}'>Submit <i class='icon-button-arrow'></i></button>";
};
