<footer id="footer" class="grid-outer">
    <div class="footer-inner grid medium">

        <!-- Left -->
        <div class="left">
            <!-- Footer Menu -->
            <nav class="footer-nav">
                <?php wp_nav_menu(array('menu' => 1, 'container' => false, 'menu_class' => 'footer-menu')); ?>
            </nav>
        </div>


        <!-- Footer Logo -->
        <a href="<?php bloginfo('url'); ?>" id="footer-logo" title="Difinative"><img src="<?php bloginfo('template_url'); ?>/assets/img/footer-logo.svg" alt="Difinative Footer Logo"></a>


        <!-- Right -->
        <div class="right">

            <!-- Go to Top -->
            <a href="#" id="go-to-top" title="Go to Top">Go to top</a>

        </div>

    </div>
</footer>


<!-- Modals - Maze -->
<?php
$contact = get_field('maze', 'options');
?>
<div class="modal-wrapper" id="modal-maze">
    <div class="modal-container">
        <div class="modal color-white">

            <!-- Close Modal Button -->
            <a href="#" class="close-modal-button" title="Close modal"><i class="icon-menu-button-close"></i></a>

            <!-- Text -->
            <div class="text">

                <!-- Show -->
                <div class="show show-hide">
                    <h3><?php echo $contact['title']; ?></h3>
                    <small><?php echo $contact['text']; ?></small>

                    <!-- Bottom Text -->
                    <div class="bottom-text">
                        <h6><?php echo $contact['subtitle']; ?></h6>
                        <p><?php echo $contact['second_text']; ?></p>
                        <h6><a href="mailto:<?php echo $contact['email']; ?>" target="_blank"><?php echo $contact['email']; ?></a></h6>
                    </div>
                </div>

                <!-- Hide -->
                <div class="hide show-hide">
                    <h3><?php echo $contact['form_title'] ?></h3>
                    <small><?php echo $contact['form_text'] ?></small>
                    <?php echo do_shortcode('[gravityform id="2" title="false" description="false" ajax="true"]') ?>

                    <a href="#" class="button play-again">Play Again <i class="icon-button-arrow"></i></a>
                </div>

            </div>


            <!-- Maze -->
            <div class="maze">
                <canvas id="maze-canvas" width="676" height="676">
                    This text is displayed if your browser does not support HTML5 Canvas.
                </canvas>
                <script type="text/javascript" src="<?php bloginfo('template_url'); ?>/assets/js/maze.min.js"></script>
                <!-- Mobile Maze Buttons -->
                <div class="mobile-opad set outline">
                    <nav class="o-pad">
                        <a class="up" href="#"></a>
                        <a class="right" href="#"></a>
                        <a class="down" href="#"></a>
                        <a class="left" href="#"></a>
                    </nav>
                </div>

            </div>

        </div>
    </div>
</div>

</div>
<?php wp_footer(); ?>
</body>

</html>