<!-- Join Us -->
<section class="join-us-container grid-outer">
    <article class="join-us grid medium">

        <h2 class="x-fade x-fade-down"><?php echo $content['title']; ?></h2>


        <?php $terms = get_terms(array(
            'taxonomy' => 'job-location',
            'hide_empty' => false,
        )); ?>

        <nav class="filters-nav x-fade x-fade-down">
            <ul class="filters-menu">
                <li><a class="active" href="#" data-filter="" title="Show All">Show All</a></li>
                <?php foreach ($terms as $term) : ?>
                    <li><a href="" data-filter="<?php echo strtolower($term->name); ?>" title="Show Germany only"><?php echo $term->name; ?></a></li>
                <?php endforeach; ?>
            </ul>
        </nav>


        <!-- Filters -->

        <!-- Items -->
        <div class="items">
            <!-- Item -->
            <?php $items = get_posts(array('post_type' => 'job', 'numberposts' => -1));
            foreach ($items as $item) : ?>
                <div data-category="<?php echo strtolower(get_the_terms($item, 'job-location')[0]->name); ?>" class="item x-fade x-fade-down">
                    <div class="item-inner">

                        <!-- Title -->
                        <div class="title">
                            <h3><?php echo $item->post_title ?></h3>
                        </div>

                        <!-- Description -->
                        <div class="desc">
                            <p><?php echo $item->post_content ?></p>
                            <a href="<?php the_field('job_link', $item); ?>" class="button dark">
                                <?php echo (get_field('text_link', $item) ? get_field('text_link', $item) : 'Apply here'); ?><i class="icon-button-arrow"></i></a>
                        </div>

                    </div>

                </div>
            <?php endforeach; ?>

        </div>

    </article>
</section>